## Oggetti Database


Gli oggetti database sono delle classi che estendono la classe astratta __\Database\Table__.

Per esempio l'oggetto __\GAzie\Azienda__ è costruito nel seguente modo:

```php
namespace GAzie;

use \GAzie\Azienda\Config as AziendaConfig;

/**
 * Class for manage azienda table
 */
class Azienda extends \Database\Table {
	
	public function __construct( $id = NULL ) {
		parent::__construct('aziend');
		$this->load( $id );
	}
	
	/**
	 * Return the config of company
	 *
	 * @return GAzie\Azienda\Config
	 */
	public function getConfig() {
		return new AziendaConfig();
	}

	public function getCurrent() {
	      if (isset($_SESSION['company_id'])) {
                        $id = $_SESSION['company_id'];
              } else {
                        $id = 1;
              }
	      $this->load( intval($id) );
	      return $this;
	}

	public function exist() {
		// Controllo se esiste l'azioneda
		return  $this->loaded();
	}

}
```

Da notare è il costruttore della classe **parent::__construct('aziend');__** il quale indica di costruire la tabella con nome ad esempio *gaz_aziend*.

* Caricare un indice

Per caricare un record è possibile indicare l'indice della tabella. Ad esempio

```php
$azienda = \GAzie\Azienda(1);
```

Potremo così richiamare i singoli campi se quell'indice esisteva:

```php
if ( $azienda->loaded() ) {
	echo "Nome azienda: " . $azienda->ragso1 . " " . $azienda->ragso2;
}
```